import bpy
from bpy.types import Operator
from ....addon.paths import FluidLabPaths
from ....addon.naming import FluidLabNaming
from ....libs.functions.libraries import append_from_library
from ....libs.functions.get_common_vars import get_common_vars


class FLUIDLAB_OT_world_add(Operator):
    bl_idname = "fluidlab.world_add"
    bl_label = "Add World"
    bl_description = "Add Fluidlab World in to current scene"
    bl_options = {'REGISTER', 'UNDO'}

    def execute(self, context):

        scn, fluidlab = get_common_vars(context, get_scn=True, get_fluidlab=True)

        worlds = bpy.data.worlds
        target_lib = FluidLabNaming.WORLD

        append_from_library(
            context,
            FluidLabPaths.LIBS_BLEND_PATH,
            "World",
            target_lib + ".blend",
            target_lib,
            only_if_not_exist=True
        )

        if FluidLabNaming.WORLD in worlds:
            fluidlab.last_world = scn.world
            scn.world = worlds.get(FluidLabNaming.WORLD)

        return {'FINISHED'}